/*
 * QrfeProtocollHandlerRFE.h
 *
 *  Created on: 15.01.2009
 *      Author: stefan.detter
 */

#ifndef QRFEPRFEREADER_H_
#define QRFEPRFEREADER_H_

#include "../QrfeReaderInterface.h"

#include <QrfeTraceModule>
#include <QrfeProtocolHandlerRFE>

class QrfeRfeReader : public QrfeReaderInterface
{
	Q_OBJECT

public:
	QrfeRfeReader(QrfeProtocolHandlerRFE* ph, QObject* parent = 0);
	virtual ~QrfeRfeReader();

public:
	virtual QrfeGlobal::Result initDevice( );

	virtual QrfeGlobal::Result setReaderName ( const QString &name );
	virtual QrfeGlobal::Result setReaderLocation ( const QString &location );

	virtual QrfeGlobal::Result getAttenuation( ushort &maxOutputPower, ushort &currentOutputPower );
	virtual QrfeGlobal::Result getMaxAttenuation ( ushort &maxAttenuation );
	virtual QrfeGlobal::Result getCurrentAttenuation ( ushort &currentAttenuation );
	virtual QrfeGlobal::Result getSensitivity ( short &maxSensitivity, short &minSensitivity, short &currentSensitivity );
	virtual QrfeGlobal::Result getMaxSensitivity ( short &maxSensitivity );
	virtual QrfeGlobal::Result getMinSensitivity ( short &minSensitivity );
	virtual QrfeGlobal::Result getCurrentSensitivity ( short &currentSensitivity );
	virtual QrfeGlobal::Result getFrequency ( uchar &mode, uchar &maxFrequencyCount, QList<uint> &frequencies );
	virtual QrfeGlobal::Result getLbtParams ( ushort &listenTime, ushort &idleTime, ushort &maxAllocTime, short &rssiThreshold );
	virtual QrfeGlobal::Result setAttenuation ( ushort value );
	virtual QrfeGlobal::Result setFrequency ( uchar mode, QList<uint> frequencies );
	virtual QrfeGlobal::Result setSensitivity ( short targetValue, short &actualValue );
	virtual QrfeGlobal::Result setLbtParams ( ushort listenTime, ushort idleTime, ushort maxAllocTime, short rssiThreshold );

	virtual QrfeGlobal::Result reboot ( );
	virtual QrfeGlobal::Result setHeartBeat ( bool on, ushort interval = 0 );
	virtual QrfeGlobal::Result setAntennaPower ( bool on );

	virtual QrfeGlobal::Result switchCommBaudrate ( ulong baudRate );
	virtual QrfeGlobal::Result switchCommInterface ( uchar id );
	virtual	QrfeGlobal::Result switchSystem ( );
    virtual QrfeGlobal::Result bootloader ( QByteArray &getMessage, QByteArray setMessage );
    virtual QrfeGlobal::Result bootloader ( QByteArray setMessage );

	virtual QrfeGlobal::Result saveSettingsPermanent ( );
	virtual QrfeGlobal::Result restoreFactorySettings ( );

	virtual QrfeGlobal::Result getParam ( ushort address, QByteArray &value );
	virtual QrfeGlobal::Result setParam ( ushort address, QByteArray value );

	virtual QrfeGlobal::Result setTagType(QrfeGlobal::TagType type);

	virtual QrfeGlobal::Result getGPIOCaps ( ulong &mask, ulong &output, ulong &input );
	virtual QrfeGlobal::Result getGPIODirection ( ulong &direction );
	virtual QrfeGlobal::Result setGPIODirection ( ulong direction );
	virtual QrfeGlobal::Result getGPIO ( ulong &mask );
	virtual QrfeGlobal::Result setGPIO ( ulong mask );
	virtual QrfeGlobal::Result clearGPIO ( ulong mask );

	virtual QrfeGlobal::Result setAntennaSequence ( const QList<QPair<uchar,ulong> > & sequence );
	virtual QrfeGlobal::Result getAntennaSequence ( QList<QPair<uchar,ulong> > & sequence );
	virtual QrfeGlobal::Result setWorkingAntenna ( uchar antennaIndex);
	virtual QrfeGlobal::Result getWorkingAntenna ( uchar & antennaIndex);

	virtual QrfeGlobal::Result activateNotification ( uchar id );
	virtual QrfeGlobal::Result deactivateNotification ( uchar id );

	virtual QrfeGlobal::Result doSingleInventory ( QList<QrfeGlobal::TagEvent> &epc );

	virtual QrfeGlobal::Result startCyclicInventory ( ulong time = 0 );
	virtual QrfeGlobal::Result stopCyclicInventory ( );

    virtual QrfeGlobal::Result applicationCommand ( const QByteArray& payload );
    virtual QrfeGlobal::Result applicationCommand ( const QByteArray& payload, QByteArray& response );

public slots:
	virtual void deviceClosed();
	virtual void heartBeatSlot();
	virtual void cyclicInventorySlot(const QrfeGlobal::TagEvent& event);
	virtual void statusRegisterChanged(const qulonglong statusRegister);
	virtual void bootUpFinished(const bool finished);
	virtual void notificationSlot(const uchar id, const QByteArray& data);
	virtual void applicationInterruptSlot(const QByteArray& data);
	virtual void gpioValuesChanged ( const ulong gpioValues );

protected:
	virtual bool filter_heartBeatSlot();
	virtual bool filter_cyclicInventorySlot(const QrfeGlobal::TagEvent& event);
	virtual bool filter_statusRegisterChanged(const qulonglong statusRegister);
	virtual bool filter_bootUpFinished(const bool finished);
	virtual bool filter_notificationSlot(const uchar id, const QByteArray& data);
	virtual bool filter_applicationInterruptSlot(const QByteArray& data);
	virtual bool filter_gpioValuesChanged(const ulong gpioValues);

private:
	virtual QByteArray 	interpretRSSItoPercent(const QByteArray& tagId, QByteArray rssi) = 0;
	virtual QString	 	interpretTriggerId(const QByteArray& tagId, uchar trigger) = 0;
	virtual QString	 	interpretStateName(const QByteArray& tagId, ushort state) = 0;

protected:
	QrfeProtocolHandlerRFE* 	m_ph;
};

#endif /* QRFEPRFEREADER_H_ */
